"use client";
import { useEffect } from "react";
import { useRouter } from "next/navigation";
import Footer from "./components/Footer/Footer";
import FeaturedVideos from "./components/Home/FeaturedVideos";
import HomeCard from "./components/Home/HomeCard";
import LatestArticles from "./components/Home/LatestArticles";
import StudentFeedback from "./components/Home/StudentFeedback";
import TopCategories from "./components/Home/TopCategories";
import WhyChooseUs from "./components/Home/WhyChooseUs";
import Navbar from "./components/Navbar/Navbar";

export default function Home() {
  const router = useRouter();

  useEffect(() => {
    router.replace("/coming-soon"); // Redirect root (/) to /coming-soon
  }, [router]);

  return (
    <>
      {true ? (
        ""
      ) : (
        <>
          <Navbar />
          <div className="pt-[120px] z-0">
            <HomeCard />
            <TopCategories />
            <FeaturedVideos />
            <WhyChooseUs />
            <StudentFeedback />
            <LatestArticles />
            <Footer />
          </div>
        </>
      )}
    </>
  );
}
